<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Pickup;

use Gls\GlsPoland\Soap\Client\Type\ResultInterface;

final class ConsignmentIdsBindingsCollection implements ResultInterface, \JsonSerializable, \IteratorAggregate
{
    /**
     * @var ConsignmentIdsBinding[]
     */
    private $items;

    /**
     * @return ConsignmentIdsBinding[]
     */
    public function getItems(): array
    {
        return $this->items;
    }

    /**
     * @return \Iterator<int, ConsignmentIdsBinding>
     */
    public function getIterator(): \Iterator
    {
        return new \ArrayIterator($this->items);
    }

    public function jsonSerialize(): array
    {
        return $this->items;
    }
}
