<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Carrier;

use Gls\GlsPoland\AdePlus\Services\Services;

final class TimeDefiniteService
{
    public const DELIVERY_BEFORE_10 = Services::DELIVERY_BEFORE_10;
    public const DELIVERY_BEFORE_12 = Services::DELIVERY_BEFORE_12;

    private const SERVICES = [
        self::DELIVERY_BEFORE_10,
        self::DELIVERY_BEFORE_12,
    ];

    private $service;

    private function __construct(string $service)
    {
        $this->service = $service;
    }

    public static function from(string $service): self
    {
        if (!in_array($service, self::SERVICES, true)) {
            throw new \InvalidArgumentException(sprintf('Unrecognized service "%s".', $service));
        }

        return new self($service);
    }

    public static function tryFrom($value): ?self
    {
        if (!in_array($value, self::SERVICES, true)) {
            return null;
        }

        return new self($value);
    }

    public function getValue(): string
    {
        return $this->service;
    }

    public function __toString(): string
    {
        return $this->service;
    }
}
