<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Country;

final class IsoCode implements \Stringable
{
    public const PATTERN = '/^[a-zA-Z]{2}$/';

    private $value;

    private function __construct(string $isoCode)
    {
        $this->value = \Tools::strtoupper($isoCode);
    }

    public static function from(string $isoCode): self
    {
        if (!preg_match(self::PATTERN, $isoCode)) {
            throw new \InvalidArgumentException(sprintf('"%s" is not a valid alpha-2 country code.', $isoCode));
        }

        return new self($isoCode);
    }

    public function getValue(): string
    {
        return $this->value;
    }

    public function __toString(): string
    {
        return $this->value;
    }
}
