<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Form\Type;

use Gls\GlsPoland\Message\CreatePickupCommand;
use Gls\GlsPoland\Translation\TranslatorAwareTrait;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\CallbackTransformer;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class CreatePickupType extends AbstractType
{
    use TranslatorAwareTrait;

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('description', TextType::class, [
                'label' => $this->getTranslator()->trans('Description', [], 'Admin.Global'),
            ])
            ->add('consignmentIds', CollectionType::class, [
                'allow_add' => true,
                'entry_type' => HiddenType::class,
                'label' => false,
            ])
            ->get('consignmentIds')
            ->addModelTransformer(new CallbackTransformer(
                static function ($consignmentIds) {
                    return $consignmentIds;
                },
                static function (array $consignmentIds) {
                    return array_map(static function ($consignmentId) {
                        return (int) $consignmentId;
                    }, $consignmentIds);
                }
            ));
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefault('data_class', CreatePickupCommand::class);
    }
}
