<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Grid\Definition\Factory;

use Gls\GlsPoland\PrestaShop\Grid\AccessibilityChecker\DeleteConsignmentAccessibilityChecker;
use Gls\GlsPoland\PrestaShop\Grid\Column\ParcelNumbersListColumn;
use Gls\GlsPoland\Translation\TranslatorAwareTrait;
use PrestaShop\PrestaShop\Core\Grid\Action\GridActionCollection;
use PrestaShop\PrestaShop\Core\Grid\Action\GridActionCollectionInterface;
use PrestaShop\PrestaShop\Core\Grid\Action\Type\SimpleGridAction;
use PrestaShop\PrestaShop\Core\Grid\Column\ColumnCollection;
use PrestaShop\PrestaShop\Core\Grid\Column\ColumnCollectionInterface;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\ActionColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\DataColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\DateTimeColumn;
use PrestaShop\PrestaShop\Core\Grid\Column\Type\Common\IdentifierColumn;
use PrestaShop\PrestaShop\Core\Grid\Definition\Factory\AbstractGridDefinitionFactory;
use PrestaShop\PrestaShop\Core\Hook\HookDispatcherInterface;
use PrestaShopBundle\Event\Dispatcher\NullDispatcher;

final class OrderConsignmentGridDefinitionFactory extends AbstractGridDefinitionFactory
{
    use TranslatorAwareTrait;
    use ConsignmentGridRowActionsTrait;

    private $authorizationChecker;

    public function __construct(DeleteConsignmentAccessibilityChecker $deleteAccessibilityChecker, ?HookDispatcherInterface $hookDispatcher = null)
    {
        parent::__construct($hookDispatcher ?? new NullDispatcher());

        $this->deleteAccessibilityChecker = $deleteAccessibilityChecker;
    }

    protected function getId(): string
    {
        return ConsignmentGridDefinitionFactory::GRID_ID;
    }

    protected function getName(): string
    {
        return $this->trans('Consignments', [], 'Modules.Glspoland.Consignment');
    }

    protected function getColumns(): ColumnCollectionInterface
    {
        if (!class_exists(DataColumn::class)) {
            class_alias(\PrestaShop\PrestaShop\Core\Grid\Column\Type\DataColumn::class, DataColumn::class);
        }

        return (new ColumnCollection())
            ->add(
                (new IdentifierColumn('id'))
                    ->setName($this->trans('ID', [], 'Admin.Global'))
                    ->setOptions([
                        'identifier_field' => 'id',
                        'sortable' => false,
                    ])
            )
            ->add(
                (new DataColumn('reference'))
                    ->setName($this->trans('References', [], 'Modules.Glspoland.Consignment'))
                    ->setOptions([
                        'field' => 'reference',
                        'sortable' => false,
                    ])
            )
            ->add(
                (new ParcelNumbersListColumn('parcel_numbers'))
                    ->setName($this->trans('Parcel numbers', [], 'Modules.Glspoland.Consignment'))
                    ->setOptions([
                        'field' => 'parcel_numbers',
                        'sortable' => false,
                    ])
            )
            ->add(
                (new DateTimeColumn('created_at'))
                    ->setName($this->trans('Created at', [], 'Modules.Glspoland.Consignment'))
                    ->setOptions([
                        'field' => 'created_at',
                        'format' => 'Y-m-d H:i:s',
                        'sortable' => false,
                    ])
            )
            ->add(
                (new ActionColumn('actions'))
                    ->setName($this->trans('Actions', [], 'Admin.Global'))
                    ->setOptions([
                        'actions' => $this->getRowActions(),
                    ])
            );
    }

    protected function getGridActions(): GridActionCollectionInterface
    {
        return (new GridActionCollection())
            ->add(
                (new SimpleGridAction('common_refresh_list'))
                    ->setName($this->trans('Refresh list', [], 'Admin.Advparameters.Feature'))
                    ->setIcon('refresh')
            );
    }
}
